
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
entities = ["Christianity", "Islam", "Hinduism", "Buddhism"]
protocols = [
    "Community Engagement",
    "Ritual Adherence",
    "Philanthropy",
    "Moral Teachings",
    "Educational Programs",
    "Cultural Influence",
]
# Simulated mean scores for different protocols (more distinctive values)
efficiency_means = np.array(
    [
        [88, 92, 85, 90, 80, 75],  # Christianity
        [80, 95, 70, 85, 85, 82],  # Islam
        [78, 85, 72, 78, 88, 90],  # Hinduism
        [75, 80, 68, 80, 75, 85],  # Buddhism
    ]
)

# Simulated standard deviations for scores (made more dramatic)
efficiency_std = np.array(
    [
        [5, 4, 6, 7, 5, 5],  # Christianity
        [6, 5, 7, 6, 6, 6],  # Islam
        [7, 6, 6, 5, 5, 7],  # Hinduism
        [6, 7, 8, 6, 4, 5],  # Buddhism
    ]
)
xlabel = "Religious Practices"
ylabel = "Assessment Scores (%)"
ylim = [60, 110]
legendtitle = "Criteria"


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(12, 6))
# Solemn color palette
colors = ["#5DA5DA", "#FAA43A", "#60BD68", "#F17CB0", "#B2912F", "#B276B2"]

# Bar width and positions
bar_width = 0.15

# Positions of the bar groups
r = np.arange(len(entities))

# Drawing bars for different protocols
for i in range(len(protocols)):
    ax.bar(
        r + i * bar_width,
        efficiency_means[:, i],
        yerr=efficiency_std[:, i],
        width=bar_width,
        label=protocols[i],
        capsize=3,
        color=colors[i],
        edgecolor="black",
    )

# Set x-axis labels and axis properties
ax.set_xlabel(xlabel)
ax.set_xticks(r + bar_width * (len(protocols) / 2))
ax.set_xticklabels(entities)
ax.set_ylabel(ylabel)
ax.set_ylim(ylim)  # Adjust y-axis to better fit extended range

# Customize the legend
ax.legend(loc="lower center", bbox_to_anchor=(0.5, -0.35), title=legendtitle, ncol=3)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorbar_98.pdf", bbox_inches="tight")
