
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
entities = ["Action", "Drama", "Comedy", "Science Fiction"]
protocols = [
    "Story",
    "Acting",
    "Direction",
    "Cinematography",
    "Editing",
    "Soundtrack",
]
# Simulated mean scores for different protocols (domain-specific values)
efficiency_means = np.array(
    [
        [85, 75, 80, 70, 78, 90],  # Action
        [70, 90, 75, 85, 65, 80],  # Drama
        [95, 65, 88, 60, 70, 85],  # Comedy
        [60, 85, 78, 95, 88, 70],  # Science Fiction
    ]
)

# Simulated standard deviations for scores (more diverse)
efficiency_std = np.array(
    [
        [5, 7, 6, 8, 5, 4],  # Action
        [8, 6, 7, 5, 9, 6],  # Drama
        [6, 8, 5, 10, 7, 5],  # Comedy
        [7, 9, 8, 6, 6, 7],  # Science Fiction
    ]
)
xlabel = "Movie Genre"
ylabel = "Performance Scores (%)"
ylim = [50, 110]
legendtitle = "Evaluation Criteria"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(10, 5))

# Vibrant color palette
colors = ["#FF6F61", "#6B5B95", "#88B04B", "#F7CAC9", "#92A8D1", "#955251"]

# Bar width and positions
bar_width = 0.12

# Positions of the bar groups
r = np.arange(len(entities))

# Drawing bars for different protocols
for i in range(len(protocols)):
    ax.bar(
        r + i * bar_width,
        efficiency_means[:, i],
        yerr=efficiency_std[:, i],
        width=bar_width,
        label=protocols[i],
        capsize=3,
        color=colors[i],
        edgecolor="black",
    )

# Set x-axis labels and axis properties
ax.set_xlabel(xlabel)
ax.set_xticks(r + bar_width * (len(protocols) / 2))
ax.set_xticklabels(entities)
ax.set_ylabel(ylabel)
ax.set_ylim(ylim)  # Adjust y-axis to better fit extended range

# Customize the legend
ax.legend(loc="lower center", bbox_to_anchor=(0.5, -0.4), title=legendtitle, ncol=3)

# Additional plot formatting
plt.tight_layout()
plt.grid(visible=False)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorbar_99.pdf", bbox_inches="tight")
