
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data for plotting
categories = ["Revenue Growth", "Customer Satisfaction", "Market Share", "Operational Efficiency", "Employee Engagement"]
means = [0.30, 0.25, 0.23, 0.20, 0.18]
errors = [0.05, 0.04, 0.03, 0.02, 0.02]
dataset_mean = [0.23]

# Text labels
xlabel = "Performance Metrics (Percentage)"
ylabel = "Business Areas"
title = "Business Performance Metrics Analysis"
legend_mean_label = "Mean"
legend_dataset_label = "Dataset Mean"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data
plt.figure(figsize=(10, 7))  # Adjusting figure size

# Define color palette
mean_color = "#1f78b4"  # Navy blue for means
error_color = "#a6cee3"  # Light blue for errors

plt.errorbar(
    means,
    categories,
    xerr=errors,
    fmt="s",  # Square markers
    color=mean_color,
    ecolor=error_color,
    capsize=5,
    label=legend_mean_label,
)

# Adding vertical line for dataset mean
plt.axvline(dataset_mean, linestyle="--", color="gray", linewidth=2, label=legend_dataset_label)

# Customizing the plot
plt.xlabel(xlabel, fontsize=14)
plt.ylabel(ylabel, fontsize=14)
plt.title(title, fontsize=16)
plt.legend()

# ===================
# Part 4: Saving Output
# ===================
# Adjusting the layout and saving the figure
plt.tight_layout()
plt.savefig("errorpoint_25.pdf", bbox_inches="tight")
