
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data for plotting
categories = ["Sunny", "Rainy", "Cloudy", "Windy", "Snowy"]
means = [25.0, 18.0, 20.0, 15.0, -5.0]
errors = [2.0, 3.0, 2.5, 2.0, 1.0]
dataset_mean = [14.6]
xlabel = "Average Temperature (°C)"
label = "Overall Mean"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data
plt.figure(figsize=(10, 6))  # Adjusting figure size for better readability
plt.errorbar(
    means,
    categories,
    xerr=errors,
    fmt="o",
    color="#1f77b4",  # Blue color for points
    ecolor="#ff7f0e", # Orange color for error bars
    capsize=5,
    label="Temperature Mean",
)
plt.axvline(dataset_mean, linestyle="--", color="#2ca02c", label=label)  # Green dashed line for mean

# Customizing the plot
plt.xlabel(xlabel, fontsize=14)
plt.ylabel('Weather Conditions', fontsize=14)
plt.title('Average Temperatures for Various Weather Conditions', fontsize=16)
plt.legend()

# ===================
# Part 4: Saving Output
# ===================
# Adjusting the layout and saving the figure
plt.tight_layout()
plt.savefig("errorpoint_26.pdf", bbox_inches="tight")
