
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)

# Data for plotting
authors = [
    "Smith et al.",
    "Johnson and Lee",
    "Becker et al.",
    "Nash et al.",
    "Harris et al.",
    "Wood et al.",
    "Chu et al.",
    "Garcia et al.",
    "Patel et al.",
    "Kim and Park",
]
values = [
    1.2,
    1.1,
    1.4,
    1.3,
    1.25,
    1.35,
    1.15,
    1.27,
    1.4,
    1.3,
]
errors = [
    [0.05, -0.06],
    [0.07, -0.05],
    [0.06, -0.07],
    [0.08, -0.09],
    [0.09, -0.08],
    [0.07, -0.06],
    [0.06, -0.06],
    [0.05, -0.05],
    [0.1, -0.1],
    [0.09, -0.09],
]
methods = [
    "Model A: 2000-2010",
    "Model B: 2000-2010",
    "Model C: 2000-2020",
    "Model D: 2010-2020",
    "Model E: 2005-2015",
    "Model F: 1990-2000",
    "Model G: 1980-1990",
    "Model H: 1970-1980",
    "Model I: 1960-1970",
    "Model J: 1950-1960",
]
xticks = np.arange(1.0, 1.5, 0.1)
xlim = [1.0, 1.5]
xvline = 1.28
xvspan = [1.25, 1.30]

# Text Label Parameters
xlabel = "Temperature Change (°C)"
title = "Average Temperature Change Over Decades"
supertitle = "Comparative Analysis of Different Environmental Studies"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, ax = plt.subplots(figsize=(10, 8))

# Error bars with different positive and negative values
for i, (author, value, error) in enumerate(zip(authors, values, errors)):
    ax.errorbar(
        value,
        i,
        xerr=[[abs(error[1])], [error[0]]],
        fmt="o",
        color="blue",
        ecolor="green",
        capsize=3,
    )
    ax.text(
        value,
        i - 0.15,
        r"$%.2f^{+%.2f} _{-%.2f}$" % (value, error[0], abs(error[1])),
        va="center",
        ha="center",
        fontsize=9,
    )

# Highlighted region with adjusted color and alpha
ax.axvspan(xvspan[0], xvspan[1], color="cyan", alpha=0.3)

# Text for methods with adjusted font size
for i, method in enumerate(methods):
    ax.text(1.5, i, method, va="center", ha="left", fontsize=11)

# Set labels and title
ax.set_yticks(range(len(authors)))
ax.set_yticklabels(authors)
ax.set_xlabel(xlabel, fontsize=12)
ax.set_xlim(xlim)
ax.invert_yaxis()
ax.axvline(x=xvline, linestyle="--", color="red")

# Adjust x-axis ticks and labels
ax.set_xticks(xticks)
ax.set_xticklabels([f"{x:.1f}" for x in xticks])

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save/show the plot
plt.suptitle(supertitle, fontsize=14, fontweight='bold')
plt.title(title, fontsize=12)
plt.tight_layout()
plt.savefig("errorpoint_27.pdf", bbox_inches="tight")
