
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data
categories = [
    "Classics",
    "Science Fiction",
    "Fantasy",
    "Non-Fiction",
    "Mystery",
    "Biographies",
]
unique_speaker_mean = [8, 10, 12, 9, 11, 13]
unique_shouter_mean = [3, 5, 6, 4, 5, 7]
unique_speaker_error = [0.8, 1.2, 1.0, 1.1, 0.9, 1.4]
unique_shouter_error = [0.4, 0.6, 0.8, 0.5, 0.7, 0.9]
labels = ["Unique speaker count mean", "Unique shouter count mean"]
ylabel = "Number of Speakers"
xlabel = "Literature Categories"
legendlabel = "Dataset unique shouter count mean"
title = "Speaker and Shouter Mean Count by Literature Category"
supertitle = "Analysis of Speaker and Shouter Trends in Literature Domains"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, ax = plt.subplots(figsize=(10, 6))
ax.errorbar(
    categories,
    unique_speaker_mean,
    yerr=unique_speaker_error,
    fmt="s",
    color="green",
    label=labels[0],
)
ax.errorbar(
    categories,
    unique_shouter_mean,
    yerr=unique_shouter_error,
    fmt="^",
    color="purple",
    label=labels[1],
)

# Customization
ax.set_ylabel(ylabel)
ax.set_xlabel(xlabel)
ax.set_title(title)
ax.set_xticklabels(categories, rotation=45, ha="right")
ax.axhline(
    y=np.mean(unique_shouter_mean),
    color="orange",
    linestyle="--",
    label=legendlabel,
)
ax.legend()

# Super Title
fig.suptitle(supertitle, fontsize=14)

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("errorpoint_30.pdf", bbox_inches="tight")
