
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data for technology domain
categories = [
    "Artificial Intelligence",
    "Cybersecurity",
    "Software Development",
    "Cloud Computing",
    "Blockchain",
    "Data Science",
]

unique_speaker_mean = [20, 18, 25, 22, 24, 26]  # Generated mean values
unique_shouter_mean = [7, 8, 6, 9, 7, 10]  # Generated mean values
unique_speaker_error = [2, 1.8, 2.5, 2.2, 2.4, 2.6]  # Generated error values
unique_shouter_error = [1, 0.9, 1.2, 1.1, 1.3, 1.5]  # Generated error values

# Text labels
labels = ["Unique speaker count mean", "Unique shouter count mean"]
ylabel = "Number of speakers and shouters"
axlabel = "Average unique shouter count mean"
title = "Technology Domain: Speaker and Shouter Statistics"
legendlabels = ["Mean speaker count", "Mean shouter count", "Overall shouter mean"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, ax = plt.subplots(figsize=(10, 6))

# Error bars with custom styles
ax.errorbar(
    categories,
    unique_speaker_mean,
    yerr=unique_speaker_error,
    fmt="o",
    color="#1f77b4",
    label=labels[0],
    ecolor='#1f77b4',
    elinewidth=2,
    capsize=5,
    marker='s',
    markersize=7
)
ax.errorbar(
    categories,
    unique_shouter_mean,
    yerr=unique_shouter_error,
    fmt="o",
    color="#ff7f0e",
    label=labels[1],
    ecolor='#ff7f0e',
    elinewidth=2,
    capsize=5,
    marker='^',
    markersize=7
)

# Customization
ax.set_ylabel(ylabel)
ax.set_xticklabels(categories, rotation=45, ha="right")
ax.axhline(
    y=np.mean(unique_shouter_mean),
    color="grey",
    linestyle="--",
    label=axlabel,
)

# Adding title and legend
ax.set_title(title)
ax.legend()

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("errorpoint_31.pdf", bbox_inches="tight")
