
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for plotting
categories = [
    "CARDIOLOGY",
    "NEUROLOGY",
    "ORTHOPEDICS",
    "PEDIATRICS",
    "DERMATOLOGY",
]  # Capitalized category labels
means = [0.75, 0.65, 0.80, 0.70, 0.60]
errors = [0.05, 0.10, 0.06, 0.07, 0.08]
downerrors = [0.04, 0.08, 0.05, 0.06, 0.07]
legendtitles = ["Overall Treatment Success Rate", "Individual Category Mean"]
texttitle = "Overall Mean Success Rate"
ylabel = "Treatment Success Rate (Fraction of patients)"
xlabel = "Medical Specialties"
dataset_mean = 0.72

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data
fig, ax = plt.subplots(figsize=(10, 7))  # Adjusting figure size for clarity

# Custom color scheme
color = "teal"
error_color = "darkslateblue"

ax.errorbar(
    categories,
    means,
    yerr=[errors, downerrors],
    fmt="s",
    color=color,
    ecolor=error_color,
    capsize=5,
    markersize=8,
    markerfacecolor='white',
)

# Adding a legend with both "Overall Treatment Success Rate" and "Individual Category Mean"
mean_line = ax.errorbar([], [], yerr=[], fmt="s", color=color, ecolor=error_color, capsize=5)
dataset_mean_line = ax.axhline(y=dataset_mean, color="gray", linestyle="--", linewidth=1.5)
ax.legend(
    [dataset_mean_line, mean_line],
    legendtitles,
    loc="upper right",
    fancybox=True,
    framealpha=1,
    shadow=True,
    borderpad=1,
)

# Adding a horizontal line for dataset mean and text annotation with a white background
ax.text(
    0.95,
    dataset_mean,
    texttitle,
    va="center",
    ha="right",
    backgroundcolor="white",
    transform=ax.get_yaxis_transform(),
)

# Setting labels
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title("Success Rates in Medical Specialties")
plt.xticks(rotation=30)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorpoint_33.pdf", bbox_inches="tight")
