
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for plotting
categories = [
    "World War II",
    "American Civil War",
    "French Revolution",
    "Industrial Revolution",
    "Fall of the Berlin Wall",
]  # Historical event labels

means = [0.75, 0.65, 0.80, 0.55, 0.60]
errors = [0.05, 0.04, 0.07, 0.03, 0.06]
downerrors = [0.04, 0.03, 0.06, 0.02, 0.05]

legendtitles = ["Overall Mean", "Event Impact"]
texttitle = "Overall Mean"
ylabel = "Impact Significance (1 to 1.0)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data
fig, ax = plt.subplots(figsize=(10, 6))  # Adjusted figure size

# Custom colors
color = "#8b4513"  # SaddleBrown
error_color = "#a52a2a"  # Brown
mean_line_color = "#808080"  # Gray

# Plotting error bar
ax.errorbar(
    categories,
    means,
    yerr=[errors, downerrors],
    fmt="o",
    color=color,
    ecolor=error_color,
    capsize=5,
    markersize=8,
)

# Adding a legend with both "Mean" and "Dataset mean"
dataset_mean = 0.67  # Example overall mean
mean_line = ax.errorbar(
    [], [], yerr=[], fmt="o", color=color, ecolor=error_color, capsize=5
)
dataset_mean_line = ax.axhline(
    y=dataset_mean, color=mean_line_color, linestyle="--", linewidth=1.5
)
ax.legend(
    [dataset_mean_line, mean_line],
    legendtitles,
    loc="upper right",
    fancybox=True,
    framealpha=1,
    shadow=True,
    borderpad=1,
)

# Adding a horizontal line for dataset mean and text annotation with a white background
ax.text(
    0.95,
    dataset_mean,
    texttitle,
    va="center",
    ha="right",
    backgroundcolor="white",
    transform=ax.get_yaxis_transform(),
)

# Setting labels
ax.set_ylabel(ylabel)
ax.set_title("")
plt.xticks(rotation=45)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorpoint_34.pdf", bbox_inches="tight")
