
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data for plotting
categories = [
    "EDUCATION",
    "WORKPLACE",
    "HEALTHCARE",
    "TECHNOLOGY",
    "ENTERTAINMENT",
]
means = [0.25, 0.3, 0.2, 0.15, 0.1]
errors = [0.04, 0.03, 0.05, 0.02, 0.03]
downerrors = [0.02, 0.03, 0.04, 0.01, 0.04]
legendtitles = ["Overall Mean", "Category Mean"]
texttitle = "Overall Mean"
ylabel = "Public Interest (Fraction of Survey Responses)"
xlabel = "Categories"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data
fig, ax = plt.subplots(figsize=(10, 7))

ax.errorbar(
    categories,
    means,
    yerr=[errors, downerrors],
    fmt="o",
    color="forestgreen",
    ecolor="lightcoral",
    elinewidth=2,
    capsize=6,
    markerfacecolor='blue',
    markeredgewidth=2,
)

# Adding a legend with both "Category Mean" and "Overall Mean"
overall_mean = 0.2
mean_line = ax.errorbar(
    [], [], yerr=[], fmt="o", color="forestgreen", ecolor="lightcoral", capsize=6
)
overall_mean_line = ax.axhline(
    y=overall_mean, color="indigo", linestyle="--", linewidth=1.5
)
ax.legend(
    [overall_mean_line, mean_line],
    legendtitles,
    loc="upper right",
    fancybox=True,
    framealpha=1,
    shadow=True,
    borderpad=1,
)

# Adding a horizontal line for overall mean and text annotation with a white background
ax.text(
    0.95,
    overall_mean,
    texttitle,
    va="center",
    ha="right",
    backgroundcolor="white",
    transform=ax.get_yaxis_transform(),
)

# Setting labels
ax.set_ylabel(ylabel)
ax.set_xlabel(xlabel)
ax.set_title("Public Interest in Various Societal Categories", fontsize=14, fontweight='bold')
plt.xticks(rotation=30, fontsize=10)
plt.yticks(fontsize=10)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorpoint_35.pdf", bbox_inches="tight")
