
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# example data for monthly temperatures
months = np.array([1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12])
temps = np.array([0, 2, 6, 12, 18, 22, 25, 24, 20, 14, 8, 3])
temp_err = np.array([1.5, 1.2, 1.0, 1.3, 1.1, 1.2, 1.3, 1.0, 1.1, 1.2, 1.3, 1.1])

# lower & upper error limits
lolims = np.array([0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0], dtype=bool)
uplims = np.array([0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0], dtype=bool)
ls = "None"
months_labels = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]
title = "Monthly Temperature Trends with Error Bars"
xlim = [0, 13]
xlabel = "Months"
ylabel = "Temperature (°C)"
legend_labels = [
    "Standard Error",
    "Upper Limits",
    "Lower Limits",
    "Upper and Lower Limits",
    "Random Adjustments",
]


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#e63946", "#f4a261", "#e76f51", "#2a9d8f", "#264653"]
fig, ax = plt.subplots(figsize=(10, 6))

# standard error bars
ax.errorbar(months, temps, yerr=temp_err, label=legend_labels[0], linestyle=ls, color=colors[0], marker='o')

# including upper limits
ax.errorbar(
    months,
    temps + 5,
    yerr=temp_err,
    uplims=uplims,
    label=legend_labels[1],
    linestyle=ls,
    color=colors[1],
    marker='v'
)

# including lower limits
ax.errorbar(
    months,
    temps - 5,
    yerr=temp_err,
    lolims=lolims,
    label=legend_labels[2],
    linestyle=ls,
    color=colors[2],
    marker='^'
)

# including upper and lower limits
ax.errorbar(
    months,
    temps - 10,
    yerr=temp_err,
    lolims=lolims,
    uplims=uplims,
    marker="s",
    markersize=8,
    label=legend_labels[3],
    linestyle=ls,
    color=colors[3],
)

# Mock up some limits by modifying previous data
xlolims = np.zeros_like(months)
xuplims = np.zeros_like(months)
yerr2 = np.full_like(months, 1.2)
xlolims[[4]] = True  # only limited at this index
xuplims[[9]] = True  # only limited at this index

# do the plotting
ax.errorbar(
    months,
    temps + 3,
    xerr=0.1,
    yerr=yerr2,
    xlolims=xlolims,
    xuplims=xuplims,
    marker="D",
    markersize=8,
    linestyle="none",
    label=legend_labels[4],
    color=colors[4],
)

# tidy up the figure
ax.set_xlim(xlim)
ax.set_xticks(months)
ax.set_xticklabels(months_labels)
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)

plt.legend(bbox_to_anchor=(0.5, 1.15), ncol=5, loc="upper center")

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorpoint_36.pdf", bbox_inches="tight")

