
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Simulated economic data (e.g., Consumer Price Index over 10 quarters)
quarters = np.arange(1, 11)
cpi = np.array([2.3, 2.4, 2.35, 2.5, 2.55, 2.6, 2.65, 2.7, 2.75, 2.8])
cpi_err = 0.05  # constant error
cpi_err_varied = np.array([0.05, 0.04, 0.06, 0.05, 0.04, 0.07, 0.06, 0.05, 0.04, 0.06])

# upper & lower limits to simulate different scenarios
lower_limits = np.array([0, 1, 0, 1, 0, 1, 0, 0, 1, 0], dtype=bool)
upper_limits = np.array([1, 0, 1, 0, 1, 0, 0, 1, 0, 1], dtype=bool)
no_line = "None"
chart_title = "CPI Variation with Error Limits"
x_axis_label = "Quarters"
y_axis_label = "CPI"
xlim = [0, 10.5]
labels = [
    "Standard Error",
    "Upper Limits",
    "Lower Limits",
    "Both Limits",
    "Varied Error",
]
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#377eb8", "#ff7f00", "#4daf4a", "#f781bf", "#a65628"]

fig, ax = plt.subplots(figsize=(10, 7))

# Standard error bars
ax.errorbar(quarters, cpi, yerr=cpi_err, label=labels[0], linestyle=no_line, color=colors[0])
# Including upper limits
ax.errorbar(
    quarters,
    cpi + 0.1,
    yerr=cpi_err,
    uplims=upper_limits,
    label=labels[1],
    linestyle=no_line,
    color=colors[1],
)
# Including lower limits
ax.errorbar(
    quarters,
    cpi - 0.1,
    yerr=cpi_err,
    lolims=lower_limits,
    label=labels[2],
    linestyle=no_line,
    color=colors[2],
)
# Including both upper and lower limits
ax.errorbar(
    quarters,
    cpi + 0.2,
    yerr=cpi_err,
    uplims=upper_limits,
    lolims=lower_limits,
    marker="o",
    markersize=8,
    label=labels[3],
    linestyle=no_line,
    color=colors[3],
)
# Varied error bars
ax.errorbar(
    quarters,
    cpi + 0.3,
    yerr=cpi_err_varied,
    xlolims=lower_limits,
    xuplims=upper_limits,
    marker="s",
    markersize=8,
    linestyle=no_line,
    label=labels[4],
    color=colors[4],
)

# Tidy up figure
ax.set_xlim(xlim)
ax.set_title(chart_title)
ax.set_xlabel(x_axis_label)
ax.set_ylabel(y_axis_label)
plt.legend(bbox_to_anchor=(0.5, 1.15), ncol=3, loc="upper center")

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorpoint_38.pdf", bbox_inches="tight")
