
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# example data
x = np.arange(0.1, 4, 0.5)
brightness = np.sin(x) + 0.5
contrast = np.cos(x)
brightness_error = 0.05 + 0.1 * x
contrast_error = 0.1 + 0.1 * x
brightness_asymmetric_error = [0.2 * brightness_error, brightness_error]
contrast_asymmetric_error = [0.3 * contrast_error, contrast_error]

# Labels and titles
title_brightness = "Brightness Variation with Symmetric Error"
title_contrast = "Contrast Variation with Asymmetric Error"
xlabel = "Time (s)"
ylabel_brightness = "Brightness (units)"
ylabel_contrast = "Contrast (units)"
legendlabels = ["Brightness", "Contrast"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, (ax0, ax1) = plt.subplots(figsize=(12, 6), ncols=2, sharex=True)

# Brightness plot with symmetric error
ax0.errorbar(x, brightness, yerr=brightness_error, fmt="D", color="#1f77b4", ecolor="#ff7f0e", elinewidth=2, capsize=3, label=legendlabels[0])
ax0.set_title(title_brightness)
ax0.set_xlabel(xlabel)
ax0.set_ylabel(ylabel_brightness)
ax0.legend()

# Contrast plot with asymmetric error
ax1.errorbar(x, contrast, xerr=contrast_asymmetric_error, fmt="*", color="#d62728", ecolor="#9467bd", elinewidth=2, capsize=3, label=legendlabels[1])
ax1.set_title(title_contrast)
ax1.set_xlabel(xlabel)
ax1.set_ylabel(ylabel_contrast)
ax1.legend()

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorpoint_41.pdf", bbox_inches="tight")
