
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# New dataset related to health (e.g., average heart rate over 10 days)
days = np.linspace(1, 10, 10)
heart_rate = np.random.uniform(60, 90, 10)
upper_error_hr = np.random.uniform(2, 6, 10)  # Upper error margin
lower_error_hr = np.random.uniform(1, 4, 10)  # Lower error margin
left_error_days = [0.2] * 10
right_error_days = [0.3] * 10
title = "Average Heart Rate with Asymmetric Error"
xlabel = "Days"
ylabel = "Heart Rate (BPM)"
label = "Heart Rate Errorbar"
annotation_text = "Avg HR"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(12, 8))
ax.errorbar(
    days,
    heart_rate,
    xerr=[left_error_days, right_error_days],
    yerr=[lower_error_hr, upper_error_hr],
    fmt="o",
    color="#1f77b4",
    ecolor="#ff7f0e",
    elinewidth=2,
    capsize=4,
    label=label,
    markersize=7,
    markerfacecolor="#2ca02c",
    markeredgewidth=2,
    markeredgecolor="#d62728"
)

# Adding text annotations for upper and lower errors
for i, (d, hr, uerr, lerr) in enumerate(zip(days, heart_rate, upper_error_hr, lower_error_hr)):
    ax.text(
        d + 0.3, hr + 0.5 * uerr, f"+{uerr:.2f}", va="center", ha="center", fontsize=10, color="#000000"
    )
    ax.text(
        d + 0.3, hr - 0.5 * lerr, f"-{lerr:.2f}", va="center", ha="center", fontsize=10, color="#000000"
    )

# Customizing the plot
ax.set_title(title, fontsize=16, fontweight='bold')
ax.set_xlabel(xlabel, fontsize=14)
ax.set_ylabel(ylabel, fontsize=14)
ax.legend(fontsize=12)
ax.grid(True, linestyle='--', linewidth=0.5)
ax.axhline(np.mean(heart_rate), color="gray", linestyle="--", linewidth=1.5)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorpoint_42.pdf", bbox_inches="tight")
