
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(13)
years = np.linspace(2010, 2019, 10)
tourists = np.random.uniform(50000, 100000, 10)
left_error = np.random.uniform(3000, 7000, 10)
right_error = np.random.uniform(3000, 7000, 10)

title = "Tourist Visits Over Years with Asymmetric Error"
xlabel = 'Year'
ylabel = 'Number of Tourists'
legend_label = 'Tourist Data'
annotation_offset = 1000

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(10, 7))
ax.errorbar(
    years,
    tourists,
    xerr=[left_error, right_error],
    fmt="^",
    color="#3498db",
    ecolor="#2ecc71",
    elinewidth=1,
    capsize=5,
    linestyle='dashed',
    label=legend_label,
)
for i, (xi, yi, lefterror, righterror) in enumerate(zip(years, tourists, left_error, right_error)):
    ax.text(
        xi - 0.8 * lefterror,
        yi + annotation_offset,
        r"${-%.1f}$" % (lefterror),
        va="center",
        ha="center",
        fontsize=9,
    )
    ax.text(
        xi + 0.8 * righterror,
        yi + annotation_offset,
        r"${+%.1f}$" % (righterror),
        va="center",
        ha="center",
        fontsize=9,
    )
ax.set_title(title, fontsize=16)
ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)
ax.legend(loc="upper left", fontsize=10)
ax.yaxis.grid(True)
ax.set_ylim(60000,105000)
# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorpoint_47.pdf", bbox_inches="tight")
