
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42) 
# New data context: Population, Literacy Rate, Employment Rate over 6 years
years = np.arange(2015, 2021)

population_growth = np.random.uniform(70, 90, 6)  # in million
literacy_rate = np.random.uniform(75, 85, 6)  # in percentage
employment_rate = np.random.uniform(50, 65, 6)  # in percentage

pop_error = [np.random.uniform(1, 3, 6), np.random.uniform(1, 3, 6)]
lit_error = [np.random.uniform(1, 2, 6), np.random.uniform(1, 2, 6)]
emp_error = np.random.uniform(1, 3, 6)

title = "Societal Trends Over Years"
xvline = 2018
ylabel_population = "Population (in millions)"
ylabel_literacy = "Literacy Rate (%)"
ylabel_employment = "Employment Rate (%)"

legend_label = 'Employment Rate'

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, (ax0, ax1, ax2) = plt.subplots(figsize=(8, 10), nrows=3, sharex=True)

colors = ["#2b83ba", "#abdda4", "#fdae61", "#d7191c", "#2c7bb6", "#fdae61"]

# Population Growth subplot with symmetric vertical error bars
for i in range(len(years)):
    ax0.errorbar(
        years[i],
        population_growth[i],
        yerr=[[pop_error[0][i]], [pop_error[1][i]]],
        fmt="o",
        color=colors[i],
        capsize=4,
    )
    ax0.text(years[i] - 0.5, population_growth[i] + 0.5, f"{population_growth[i]:.2f}", fontsize=8, ha="right")
ax0.set_title(title)
ax0.set_ylabel(ylabel_population)
ax0.axhline(y=80, linestyle="--", color="#555555")
ax0.yaxis.grid(True)
ax0.xaxis.grid(False)

# Literacy Rate subplot with symmetric horizontal error bars
for i in range(len(years)):
    ax1.errorbar(
        years[i],
        literacy_rate[i],
        xerr=[[lit_error[0][i]], [lit_error[1][i]]],
        fmt="o",
        color=colors[i],
        markersize=8,
    )
    ax1.text(years[i] + 0.1, literacy_rate[i] + 0.2, f"{literacy_rate[i]:.2f}", fontsize=8, ha="left")
ax1.set_title(title)
ax1.set_ylabel(ylabel_literacy)
ax1.axvline(x=xvline, linestyle="--", color="#555555")
ax1.xaxis.grid(True)
ax1.yaxis.grid(False)

# Employment Rate subplot with symmetric vertical error bars
ax2.errorbar(years, employment_rate, yerr=emp_error, fmt="*", color="#444444", capsize=2)
ax2.set_title(title)
ax2.set_ylabel(ylabel_employment)
ax2.yaxis.grid(True)
ax2.xaxis.grid(False)
ax2.legend([legend_label])

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorpoint_50.pdf", bbox_inches="tight")
