
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data for plotting
categories = ["Running", "Cycling", "Walking", "Yoga", "Swimming"]
average_calories = [600, 500, 250, 200, 700]  # Average calories burned per hour
errors = [50, 40, 30, 20, 60]  # Calorie variance
world_mean = [450]  # Global average calories burned per hour
xlabel = "Average Calories Burned per Hour"
label = "Global Average Calories Burned"
plot_title = 'Average Calorie Burn by Exercise Type'

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data
plt.figure(figsize=(10, 7))  # Adjusting figure size for better readability
plt.errorbar(
    average_calories,
    categories,
    xerr=errors,
    fmt="o",
    color="#0077b6",
    ecolor="#48cae4",
    capsize=5,
    elinewidth=2,
    markeredgewidth=2,
    label="Exercise Type Mean",
)
plt.axvline(world_mean[0], color="#f77f00", linestyle="--", linewidth=3, label=label)

# Customizing the plot
plt.xlabel(xlabel)
plt.title(plot_title)
plt.legend(loc='upper right')
plt.grid(True, linestyle=':', linewidth=0.5, alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting the layout and saving the figure
plt.tight_layout()
plt.savefig("errorpoint_54.pdf", bbox_inches="tight")
