
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for plotting
cities = ["New York", "Los Angeles", "Chicago", "Houston", "Phoenix"]
average_rainfall = [1200, 500, 900, 1300, 250]  # Average annual rainfall (mm)
errors = [100, 50, 80, 150, 30]  # Rainfall variance (mm)
world_mean_rainfall = [750]  # Global average rainfall (mm)

# Text labels
xlabel = "Average Annual Rainfall (mm)"
label = "Global Average Rainfall"
plot_title = 'Average Annual Rainfall by City'

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data
plt.figure(figsize=(10, 7))  # Adjusting figure size for better readability
plt.errorbar(
    average_rainfall,
    cities,
    xerr=errors,
    fmt="o",
    color="#1f77b4",
    ecolor="#ff7f0e",
    capsize=5,
    elinewidth=2,
    markeredgewidth=2,
    label="City Rainfall Mean",
)
plt.axvline(world_mean_rainfall[0], color="#2ca02c", linestyle="--", linewidth=3, label=label)

# Customizing the plot
plt.xlabel(xlabel)
plt.title(plot_title)
plt.legend(loc='upper right')
plt.grid(True, linestyle='--', linewidth=0.5, alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting the layout and saving the figure
plt.tight_layout()
plt.savefig("errorpoint_56.pdf", bbox_inches="tight")
