
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data (example values, replace with actual data)
categories = [
    "Education",
    "Healthcare",
    "Employment",
    "Public Safety",
    "Transportation",
    "Housing",
]
unique_initiative_mean = [
    60,
    55,
    50,
    48,
    58,
    52,
]  # Replace with actual mean values for unique initiatives
unique_challenge_mean = [
    25,
    28,
    23,
    27,
    30,
    26,
]  # Replace with actual mean values for unique challenges
unique_initiative_error = [
    6,
    5,
    4,
    5.5,
    5,
    4.5,
]  # Replace with actual error values for unique initiatives
unique_challenge_error = [
    3,
    3.5,
    3,
    3.25,
    3.5,
    3.75,
]  # Replace with actual error values for unique challenges
labels = ["Unique initiative count mean", "Unique challenge count mean"]
ylabel = "Number of Unique Initiatives"
axlabel = "Average Unique Challenge Count"
title = "Average Number of Unique Initiatives and Challenges in Different Societal Fields"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, ax = plt.subplots(
    figsize=(12, 8)
)  # Adjust the size to match the original image's dimensions
ax.errorbar(
    categories,
    unique_initiative_mean,
    yerr=unique_initiative_error,
    fmt="o",
    color="#1f77b4",
    label=labels[0],
    capsize=10,
    markersize=8,
    elinewidth=2,
    markeredgewidth=2,
)
ax.errorbar(
    categories,
    unique_challenge_mean,
    yerr=unique_challenge_error,
    fmt="s",
    color="#ff7f0e",
    label=labels[1],
    capsize=10,
    markersize=8,
    elinewidth=2,
    markeredgewidth=2,
)

# Customization
ax.set_ylabel(ylabel)
ax.set_xticklabels(categories, rotation=45, ha="right")
ax.axhline(
    y=np.mean(unique_challenge_mean),
    color="grey",
    linestyle="--",
    linewidth=2,
    label=axlabel,
)
ax.legend()
ax.set_title(title)
ax.grid(True, linestyle='--', linewidth=0.5)

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("errorpoint_60.pdf", bbox_inches="tight")

