
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for Law domain
categories = [
    "Criminal",
    "Civil",
    "Corporate",
    "Family",
    "Environmental",
    "Intellectual Property",
]
unique_speaker_mean = [120, 95, 75, 130, 85, 60]  # Mean values for legal cases participants
unique_shouter_mean = [1100, 800, 600, 1400, 900, 450]  # Mean values for observers in legal cases
unique_speaker_error = [12, 18, 10, 15, 11, 14]  # Error values for participants
unique_shouter_error = [130, 110, 90, 150, 100, 80]  # Error values for observers
labels = ["Lawyers count mean", "Attendees count mean"]
ylabel = "Number of Lawyers"
axlabel = "Average Attendees Count"
title = "Analysis of Lawyers and Attendees in Legal Cases"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================

# Plotting
fig, ax = plt.subplots(figsize=(10, 6))

# Error bars and markers
ax.errorbar(
    categories,
    unique_speaker_mean,
    yerr=unique_speaker_error,
    fmt="o",
    color="#1f77b4",  # A shade of blue
    marker="s",
    markersize=8,
    label=labels[0],
)
ax.errorbar(
    categories,
    unique_shouter_mean,
    yerr=unique_shouter_error,
    fmt="o",
    color="#2ca02c",  # A shade of green
    marker="D",
    markersize=8,
    label=labels[1],
)

# Customization
ax.set_ylabel(ylabel)
ax.set_xticklabels(categories, rotation=45, ha="right")
ax.axhline(
    y=sum(unique_shouter_mean) / len(unique_shouter_mean),
    color="gray",
    linestyle="--",
    linewidth=1.5,
    label=axlabel,
)

# Title and Grid
ax.set_title(title)
ax.grid(True, linestyle="--", linewidth=0.5)

# Legend
ax.legend()

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("errorpoint_64.pdf", bbox_inches="tight")
