
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np  # Importing numpy for handling data

# Data for Population Analysis
categories = [
    "City A",
    "City B",
    "City C",
    "City D",
    "City E",
    "City F",
]
resident_mean = [50000, 75000, 30000, 120000, 45000, 60000]  # Example mean values for residents
tourist_mean = [15000, 30000, 20000, 50000, 25000, 35000]  # Example mean values for tourists
resident_error = [5000, 7000, 3000, 10000, 4000, 6000]  # Example error values for residents
tourist_error = [2000, 5000, 3000, 7000, 3500, 4500]  # Example error values for tourists
labels = ["Resident Count Mean", "Tourist Count Mean"]
ylabel = "Number of People"
axlabel = "Average Tourist Count"
title = "Population Analysis: Residents vs Tourists"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================

# Plotting
fig, ax = plt.subplots(figsize=(10, 6))

# Error bars and markers
ax.errorbar(
    categories,
    resident_mean,
    yerr=resident_error,
    fmt="o",
    color="skyblue",
    marker="s",  # Square marker
    markersize=8,
    label=labels[0],
)
ax.errorbar(
    categories,
    tourist_mean,
    yerr=tourist_error,
    fmt="o",
    color="lightgreen",
    marker="o",  # Circle marker
    markersize=8,
    label=labels[1],
)

# Customization
ax.set_ylabel(ylabel)
ax.set_xticklabels(categories, rotation=45, ha="right")
ax.axhline(
    y=sum(tourist_mean) / len(tourist_mean),
    color="grey",
    linestyle="--",
    linewidth=1.5,
    label=axlabel,
)

# Title and Grid
ax.set_title(title)
ax.grid(True, linestyle="--", linewidth=0.5)

# Legend
ax.legend()

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("errorpoint_65.pdf", bbox_inches="tight")
