
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data for plotting
categories = [
    "Education",
    "Healthcare",
    "Employment",
    "Income",
    "Housing",
]
means = [0.75, 0.60, 0.55, 0.50, 0.45]  # Example mean satisfaction rates
errors = [0.05, 0.03, 0.04, 0.05, 0.03]  # Example upper error margins
downerrors = [0.04, 0.02, 0.03, 0.04, 0.02]  # Example lower error margins
legendtitles = ["Dataset Mean", "Mean Satisfaction"]
texttitle = "Societal Metrics Satisfaction"
xlabel = "Categories"
ylabel = "Satisfaction Rate (Fraction of total responses)"
title = "Societal Metrics Satisfaction Rates"
dataset_mean = 0.57

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data
fig, ax = plt.subplots(figsize=(10, 8))

# Adjusting color scheme and marker style
ax.errorbar(
    categories,
    means,
    yerr=[errors, downerrors],
    fmt="s",
    color="forestgreen",
    ecolor="forestgreen",
    capsize=5,
    markersize=8,
    markerfacecolor="darkblue",
    markeredgewidth=2,
)

# Adding a legend with both "Mean Satisfaction" and "Dataset Mean"
mean_line = ax.errorbar(
    [], [], yerr=[], fmt="^", color="forestgreen", ecolor="forestgreen", capsize=5, markersize=8,
    markerfacecolor="darkblue", markeredgewidth=2
)
dataset_mean_line = ax.axhline(
    y=dataset_mean, color="darkred", linestyle="--", linewidth=2
)
ax.legend(
    [dataset_mean_line, mean_line],
    legendtitles,
    loc="upper right",
    fancybox=True,
    framealpha=1,
    shadow=True,
    borderpad=1,
)

# Adding a horizontal line for dataset mean and text annotation with a white background
ax.text(
    0.95,
    dataset_mean,
    texttitle,
    va="center",
    ha="right",
    backgroundcolor="white",
    transform=ax.get_yaxis_transform(),
    fontsize=10,
    weight='bold'
)

# Setting labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)
plt.xticks(rotation=45)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorpoint_66.pdf", bbox_inches="tight")
