
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data for plotting
categories = [
    "Youth (18-25)",
    "Adults (26-40)",
    "Middle-aged (41-60)",
    "Senior (60+)",
    "Overall Population",
]
means = [0.12, 0.08, -0.15, -0.10, -0.05]  # Mean change in religious affiliation
errors = [0.03, 0.02, 0.04, 0.03, 0.02]  # Upper error margins
downerrors = [0.02, 0.01, 0.03, 0.02, 0.01]  # Lower error margins
legendtitles = ["Dataset Mean", "Mean Change"]
texttitle = "Mean Change in Religious Affiliation"
xlabel = "Demographic Groups"
ylabel = "Change in Religious Affiliation (Fraction)"
title = "Trends in Religious Affiliation Over Time"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data
fig, ax = plt.subplots(figsize=(10, 8))

# Adjusting color scheme and marker style
ax.errorbar(
    categories,
    means,
    yerr=[errors, downerrors],
    fmt="o",
    color="navy",
    ecolor="blue",
    capsize=5,
    markersize=8,
    markerfacecolor="gold",
    markeredgewidth=2,
)

# Adding a legend with both "Mean Change" and "Dataset Mean"
dataset_mean = -0.03
mean_line = ax.errorbar(
    [], [], yerr=[], fmt="^", color="navy", ecolor="blue", capsize=5, markersize=8,
    markerfacecolor="gold", markeredgewidth=2
)
dataset_mean_line = ax.axhline(
    y=dataset_mean, color="darkred", linestyle="--", linewidth=2
)
ax.legend(
    [dataset_mean_line, mean_line],
    legendtitles,
    loc="upper right",
    fancybox=True,
    framealpha=1,
    shadow=True,
    borderpad=1,
)

# Adding a horizontal line for dataset mean and text annotation with a white background
ax.text(
    0.95,
    dataset_mean,
    texttitle,
    va="center",
    ha="right",
    backgroundcolor="white",
    transform=ax.get_yaxis_transform(),
    fontsize=10,
    weight='bold'
)

# Setting labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)
plt.xticks(rotation=45)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorpoint_68.pdf", bbox_inches="tight")
