
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data for plotting: Philosophical Schools of Thought
categories = [
    "Existentialism",
    "Empiricism",
    "Rationalism",
    "Pragmatism",
    "Postmodernism",
]

# Generated mean values for the prevalence in academic literature
means = [0.25, 0.40, 0.35, 0.30, 0.45]
errors = [0.05, 0.04, 0.03, 0.04, 0.05]
downerrors = [0.02, 0.03, 0.02, 0.03, 0.04]

# Texts and labels
legendtitles = ["Mean", "Dataset mean"]
texttitle = "Overall Mean"
title = "Prevalence of Philosophical Schools in Academic Literature"
ylabel = "Prevalence Fraction"
xlabel = "Philosophical School"
dataset_mean = np.mean(means)  # Calculated dataset mean

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data
fig, ax = plt.subplots(figsize=(10, 6))

# Custom color scheme
marker_color = "mediumslateblue"
error_color = "slategray"
dataset_line_color = "gray"

ax.errorbar(
    categories,
    means,
    yerr=[errors, downerrors],
    fmt="o",
    color=marker_color,
    ecolor=error_color,
    capsize=5,
    markerfacecolor="lavender",
    markeredgewidth=2,
    markeredgecolor=marker_color,
)

# Adding a legend with both "Mean" and "Dataset mean"
mean_line = ax.errorbar(
    [], [], yerr=[], fmt="o", color=marker_color, ecolor=error_color, capsize=5
)
dataset_mean_line = ax.axhline(
    y=dataset_mean, color=dataset_line_color, linestyle="--", linewidth=1
)
ax.legend(
    [dataset_mean_line, mean_line],
    legendtitles,
    loc="upper left",
    fancybox=True,
    framealpha=1,
    shadow=True,
    borderpad=1,
)

# Adding a horizontal line for dataset mean and text annotation with a white background
ax.text(
    0.95,
    dataset_mean,
    texttitle,
    va="center",
    ha="right",
    backgroundcolor="white",
    transform=ax.get_yaxis_transform(),
)

# Setting labels and a title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)
plt.xticks(rotation=30)
plt.grid(True, which="both", axis="y", linestyle="--", linewidth=0.5)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorpoint_70.pdf", bbox_inches="tight")
