
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Environmental data: average PM2.5 concentration (µg/m³) over 10 months
x = np.arange(1, 11, 1)
y = [
    35.7,
    40.2,
    38.5,
    37.8,
    36.5,
    35.0,
    37.2,
    38.0,
    39.0,
    36.8,
]
error = np.array([3.0, 2.5, 2.8, 3.5, 3.2, 2.5, 2.8, 3.0, 3.1, 2.9])  # symmetric error
lower_error = 0.4 * error  # Adjusted asymmetric error
upper_error = error
asymmetric_error = [lower_error, upper_error]

title1 = "Average PM2.5 Concentration with Symmetric Error Margins"
title2 = "Average PM2.5 Concentration with Asymmetric Error Margins"
xlabel = "Time (Months)"
ylabel = "PM2.5 Concentration (µg/m³)"
legend_label = "PM2.5 Data"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, (ax0, ax1) = plt.subplots(figsize=(12, 6), ncols=2, sharex=True)

# Plot with symmetric error
ax0.errorbar(
    x,
    y,
    yerr=error,
    fmt="o",
    color="mediumseagreen",
    ecolor="darkred",
    elinewidth=2,
    capsize=5,
    label=legend_label,
)
ax0.set_title(title1, fontsize=14)
ax0.set_xlabel(xlabel, fontsize=12)
ax0.set_ylabel(ylabel, fontsize=12)
ax0.legend()

# Plot with asymmetric error
ax1.errorbar(
    x,
    y,
    yerr=asymmetric_error,
    fmt="d",
    color="royalblue",
    ecolor="darkorange",
    elinewidth=2,
    capsize=5,
    label=legend_label,
)
ax1.set_title(title2, fontsize=14)
ax1.set_xlabel(xlabel, fontsize=12)
ax1.set_yscale("log")
ax1.legend()

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorpoint_73.pdf", bbox_inches="tight")
