
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Cities and months
cities = ["City A", "City B", "City C"]
months = ["Jan", "Feb", "Mar", "Apr", "May", "Jun"]

# Positions for x-axis
x_positions = np.arange(len(months))

# Temperature data for six months
city_a_temperatures = np.random.uniform(5, 15, len(months))
city_b_temperatures = np.random.uniform(10, 20, len(months))
city_c_temperatures = np.random.uniform(15, 25, len(months))

# Error bars (symmetric)
city_a_error = [np.random.uniform(1, 3, len(months)), np.random.uniform(1, 3, len(months))]
city_b_error = [np.random.uniform(2, 4, len(months)), np.random.uniform(2, 4, len(months))]
city_c_error = np.random.uniform(1, 2, len(months))

# Horizontal line position for ideal temperature range
ideal_temp_range = [12, 18]

# Titles and labels
titles = ["City A Temperature Readings", "City B Temperature Readings", "City C Temperature Readings"]
xlabel = "Months"
ylabel = "Temperature (°C)"
legendlabels = ["City A", "City B", "City C"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with three subplots and shared x-axis
fig, (ax0, ax1, ax2) = plt.subplots(figsize=(8, 12), nrows=3, sharex=True)
city_a_colors = plt.get_cmap("Blues")(np.linspace(0.2, 0.8, len(months)))
city_b_colors = plt.get_cmap("Oranges")(np.linspace(0.2, 0.8, len(months)))
city_c_color = "#D62728"  # red

# First subplot with symmetric vertical error bars for City A
for i in range(len(x_positions)):
    ax0.errorbar(
        x_positions[i],
        city_a_temperatures[i],
        yerr=[[city_a_error[0][i]], [city_a_error[1][i]]],
        fmt="o",
        color=city_a_colors[i],
        capsize=4,
    )
    ax0.text(
        x_positions[i] - 0.1,
        city_a_temperatures[i] + 0.5,
        f"{city_a_temperatures[i]:.1f}",
        fontsize=8,
        ha="right",
    )
ax0.set_title(titles[0])
ax0.axhline(y=np.mean(ideal_temp_range), linestyle="--", color="green")
ax0.yaxis.grid(True)
ax0.xaxis.grid(False)

# Second subplot with symmetric vertical error bars for City B
for i in range(len(x_positions)):
    ax1.errorbar(
        x_positions[i],
        city_b_temperatures[i],
        yerr=[[city_b_error[0][i]], [city_b_error[1][i]]],
        fmt="s",
        color=city_b_colors[i],
        capsize=4,
    )
    ax1.text(
        x_positions[i] - 0.1,
        city_b_temperatures[i] + 0.5,
        f"{city_b_temperatures[i]:.1f}",
        fontsize=8,
        ha="right",
    )
ax1.set_title(titles[1])
ax1.axhline(y=np.mean(ideal_temp_range), linestyle="--", color="green")
ax1.yaxis.grid(True)
ax1.xaxis.grid(False)

# Third subplot with symmetric vertical error bars for City C
ax2.errorbar(
    x_positions,
    city_c_temperatures,
    yerr=city_c_error,
    fmt="*",
    color=city_c_color,
    capsize=4,
)
ax2.set_title(titles[2])
ax2.legend(legendlabels, loc="upper left")
ax2.yaxis.grid(True)
ax2.xaxis.grid(False)

# Set overall x and y labels
fig.supxlabel(xlabel)
fig.supylabel(ylabel)

# Set x-ticks and x-tick labels
plt.xticks(ticks=x_positions, labels=months)

# Adjust layout and display the plot
plt.tight_layout()
plt.savefig("errorpoint_75.pdf", bbox_inches="tight")
