
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
months = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]

x = np.arange(len(months))  # Months
tablet_sales = np.random.uniform(2, 5, len(months))
desktop_sales = np.random.uniform(3, 7, len(months))
accessory_sales = np.random.uniform(1, 4, len(months))

error_tablet = [np.random.uniform(0.1, 0.5, len(months)), np.random.uniform(0.1, 0.5, len(months))]
error_desktop = [np.random.uniform(0.2, 1.0, len(months)), np.random.uniform(0.2, 1.0, len(months))]
error_accessory = np.random.uniform(0.1, 0.8, len(months))

chart_title = "Monthly Sales Performance of Tech Products with Error Bars"
highlight_month = 6  # July

ylabel = [
    "Tablet Sales (Thousands)",
    "Desktop Sales (Thousands)",
    "Accessory Sales (Thousands)"
]
xlabel = "Month"
legend_labels = ["Tablets", "Desktops", "Accessories"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, (ax0, ax1, ax2) = plt.subplots(figsize=(8, 12), nrows=3, sharex=True)

colors_tablet = plt.get_cmap("viridis")(np.linspace(0.2, 0.8, len(months)))
colors_desktop = plt.get_cmap("plasma")(np.linspace(0.2, 0.8, len(months)))
color_accessory = "orange"

# First subplot with symmetric vertical error bars (Tablet sales)
for i in range(len(x)):
    ax0.errorbar(
        x[i],
        tablet_sales[i],
        yerr=[[error_tablet[0][i]], [error_tablet[1][i]]],
        fmt="o",
        color=colors_tablet[i],
        capsize=4,
    )
    ax0.text(
        x[i] - 0.2,
        tablet_sales[i] + 0.1,
        f"{tablet_sales[i]:.2f}",
        fontsize=8,
        ha="right",
    )
ax0.set_title(chart_title)
ax0.axhline(y=3.5, linestyle="--", color="#6b8e23")
ax0.set_ylabel(ylabel[0])
ax0.yaxis.grid(True)
ax0.xaxis.grid(False)

# Second subplot with symmetric horizontal error bars (Desktop sales)
for i in range(len(x)):
    ax1.errorbar(
        x[i],
        desktop_sales[i],
        xerr=[[error_desktop[0][i]], [error_desktop[1][i]]],
        fmt="o",
        color=colors_desktop[i],
        markersize=8,
    )
    ax1.text(
        x[i] + 0.1,
        desktop_sales[i] + 0.1,
        f"{desktop_sales[i]:.2f}",
        fontsize=8,
        ha="left",
    )
ax1.axvline(x=highlight_month, linestyle="--", color="#d45500")
ax1.set_ylabel(ylabel[1])
ax1.yaxis.grid(True)
ax1.xaxis.grid(False)

# Third subplot with symmetric vertical error bars (Accessory sales)
ax2.errorbar(
    x, accessory_sales, yerr=error_accessory, fmt="*", color=color_accessory, capsize=2
)
for i in range(len(x)):
    ax2.text(
        x[i],
        accessory_sales[i] + 0.1,
        f"{accessory_sales[i]:.2f}",
        fontsize=8,
        ha="center",
    )
ax2.set_ylabel(ylabel[2])
ax2.yaxis.grid(True)
ax2.xaxis.grid(False)

# Set shared x-axis labels
plt.xticks(x, months)
ax2.set_xlabel(xlabel)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorpoint_78.pdf", bbox_inches="tight")
