
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

months = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]
x = np.arange(len(months))  # Months

# Temperature data (°C)
high_temps = np.random.uniform(15, 30, len(months))  # High temperatures
low_temps = np.random.uniform(5, 15, len(months))    # Low temperatures

# Precipitation data (mm)
precipitation = np.random.uniform(20, 120, len(months))

# Error data
error_high_temps = np.random.uniform(1, 3, len(months))  # Error for high temperatures
error_low_temps = np.random.uniform(1, 2, len(months))   # Error for low temperatures
error_precipitation = np.random.uniform(5, 20, len(months))

# Chart title and labels
chart_title = "Monthly Weather Data with Error Bars"
xlabel = "Month"
ylabel = ["High Temp (°C)", "Low Temp (°C)", "Precipitation (mm)"]
highlight_month = 6  # July

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with three subplots and shared x-axis
fig, (ax0, ax1, ax2) = plt.subplots(figsize=(8, 12), nrows=3, sharex=True)

# Colors
color_high_temps = "darkred"
color_low_temps = "navy"
color_precipitation = "gray"

# First subplot with high temperatures
ax0.errorbar(x, high_temps, yerr=error_high_temps, fmt="o", color=color_high_temps, capsize=4)
for i in range(len(x)):
    ax0.text(x[i] - 0.2, high_temps[i] + 0.1, f"{high_temps[i]:.2f}", fontsize=8, ha="right")
ax0.set_title(chart_title)
ax0.axhline(y=25, linestyle="--", color="#6b8e23")  # Example threshold line
ax0.set_ylabel(ylabel[0])
ax0.yaxis.grid(True)
ax0.xaxis.grid(False)

# Second subplot with low temperatures
ax1.errorbar(x, low_temps, yerr=error_low_temps, fmt="s", color=color_low_temps, markersize=8, capsize=4)
for i in range(len(x)):
    ax1.text(x[i] + 0.1, low_temps[i] + 0.1, f"{low_temps[i]:.2f}", fontsize=8, ha="left")
ax1.axvline(x=highlight_month, linestyle="--", color="#d45500")  # Highlight a specific month
ax1.set_ylabel(ylabel[1])
ax1.yaxis.grid(True)
ax1.xaxis.grid(False)

# Third subplot with precipitation
ax2.errorbar(x, precipitation, yerr=error_precipitation, fmt="*", color=color_precipitation, capsize=2)
for i in range(len(x)):
    ax2.text(x[i], precipitation[i] + 5, f"{precipitation[i]:.2f}", fontsize=8, ha="center")
ax2.set_ylabel(ylabel[2])
ax2.yaxis.grid(True)
ax2.xaxis.grid(False)

# Set shared x-axis labels
plt.xticks(x, months)
ax2.set_xlabel(xlabel)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and display the plot
plt.tight_layout()
plt.savefig("errorpoint_80.pdf", bbox_inches="tight")
