
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import networkx as nx
import numpy as np

# Create a directed graph
G = nx.DiGraph()

# Add nodes with their respective colors
nodes = {
    0: "green",     # Main Station
    1: "blue",      # Major Suburban Station
    2: "blue",      # Major Suburban Station
    3: "yellow",    # Minor Suburban Station
    4: "yellow",    # Minor Suburban Station
    5: "yellow",    # Minor Suburban Station
    6: "green",     # Main Station
}
for node, color in nodes.items():
    G.add_node(node, color=color)

# Add edges with labels and styles
edges = [
    (0, 1, "Route 1"), (1, 2, "Route 2"), (2, 3, "Route 3"),
    (3, 4, "Route 4"), (4, 5, "Route 5"), (5, 6, "Route 6")
]

# Define node positions in a circular layout
pos = nx.circular_layout(G)

# Custom labels and title
xlabel = 'X Axis Label'
ylabel = 'Y Axis Label'
title = 'Public Transportation Network'
legend_labels = {
    'green': 'Main Station',
    'blue': 'Major Suburban Station',
    'yellow': 'Minor Suburban Station'
}

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(8, 8))

# Draw nodes with color attribute
node_colors = [G.nodes[node]["color"] for node in G.nodes]
nx.draw_networkx_nodes(G, pos, node_color=node_colors, node_size=700, ax=ax)

# Draw edges with labels and custom styles
nx.draw_networkx_edges(G, pos, arrows=True, ax=ax)
edge_labels = {(u, v): G[u][v]["label"] for u, v in G.edges}
nx.draw_networkx_edge_labels(G, pos, edge_labels=edge_labels, ax=ax)

# Add legend for node colors
for color, desc in legend_labels.items():
    ax.plot([], [], marker='o', color=color, linestyle='None', markersize=10, label=desc)

# Remove axis
plt.axis("off")

# Add title and labels
plt.title(title)

# Add a legend
plt.legend(loc='upper right')

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("graph_21.pdf", bbox_inches="tight")
