
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import networkx as nx

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Create a directed graph
G = nx.DiGraph()
# Text Labels and Other Parameters
team_labels = {
    0: "Team A",
    1: "Team B",
    2: "Team C",
    3: "Team D",
    4: "Team E",
    5: "Team F",
    6: "Team G",
}
match_labels = ["Round 1", "Quarterfinal", "Semifinal", "Final"]
# Define match results/progress using edges
tournament_edges = [
    (0, 1, "Win"), (0, 2, "Loss"),  # Round 1
    (1, 3, "Win"), (1, 4, "Loss"),  # Quarterfinal
    (3, 5, "Win"), (3, 6, "Loss"),  # Semifinal
    (5, 6, "Final")                # Final
]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Define teams with distinct colors
teams = {
    0: "#1F77B4",  # blue
    1: "#FF7F0E",  # orange
    2: "#2CA02C",  # green
    3: "#D62728",  # red
    4: "#9467BD",  # purple
    5: "#8C564B",  # brown
    6: "#E377C2",  # pink
}

for node, color in teams.items():
    G.add_node(node, color=color, label=team_labels[node])

for u, v, label in tournament_edges:
    G.add_edge(u, v, label=label)

# Define node positions in a shell layout for better visualization
pos = nx.shell_layout(G)

fig, ax = plt.subplots(figsize=(10, 10))

# Draw nodes with custom colors
node_colors = [G.nodes[node]["color"] for node in G.nodes]
nx.draw_networkx_nodes(G, pos, node_color=node_colors, node_size=600, ax=ax)

# Draw edges with arrows and custom styles
nx.draw_networkx_edges(G, pos, arrows=True, arrowstyle='->', ax=ax)

# Draw edge labels (match outcomes)
edge_labels = {(u, v): G[u][v]["label"] for u, v in G.edges}
nx.draw_networkx_edge_labels(G, pos, edge_labels=edge_labels, font_color='blue', ax=ax)

# Draw node labels (team names)
node_labels = {node: G.nodes[node]["label"] for node in G.nodes}
nx.draw_networkx_labels(G, pos, labels=node_labels, font_size=12, font_color='black', ax=ax)

# Remove axis
plt.axis("off")

# Title and Annotations
plt.title("Sports Tournament Bracket", fontsize=15)
plt.suptitle("Tournament Progression", fontsize=20)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("graph_22.pdf", bbox_inches="tight")

