
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import networkx as nx

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(0)
# Create a random geometric graph
G = nx.random_geometric_graph(30, 0.3)

# Position the nodes based on their connections using a different layout algorithm
pos = nx.kamada_kawai_layout(G)

# Randomly select some edges to color blue
edges = list(G.edges())
blue_edges = np.random.choice(len(edges), size=int(len(edges) * 0.3), replace=False)
blue_edges = [edges[i] for i in blue_edges]

# Labels and titles
title = "Random Geometric Graph with Modified Layout"
legend_labels = ["Nodes", "Default Edges", "Highlighted Edges"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(10, 10))

# Colors
node_color = "#76c7c0"  # Teal color
default_edge_color = "#1f78b4"  # Blue color
highlighted_edge_color = "#b22222"  # Firebrick (red) color

# Draw the nodes
nx.draw_networkx_nodes(G, pos, node_size=200, node_color=node_color, ax=ax, label=legend_labels[0])

# Draw the edges
nx.draw_networkx_edges(G, pos, edge_color=default_edge_color, alpha=0.5, ax=ax, label=legend_labels[1])

# Draw the selected edges in a different color
nx.draw_networkx_edges(G, pos, edgelist=blue_edges, edge_color=highlighted_edge_color, width=2, style='dashed', ax=ax, label=legend_labels[2])

# Remove axis
plt.axis("off")

# Title and legend
plt.title(title)
plt.legend()

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("graph_24.pdf", bbox_inches="tight")
