
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import networkx as nx
import numpy as np

# Create a cycle graph with 12 nodes
G = nx.cycle_graph(12)
weights = {edge: np.random.randint(5, 20) for edge in G.edges()}
nx.set_edge_attributes(G, weights, "weight")

pos = nx.spring_layout(G, iterations=200)

labels = {
    0: "Math", 1: "Physics", 2: "Chemistry", 3: "Biology",
    4: "History", 5: "Geography", 6: "English", 7: "Art",
    8: "Music", 9: "PE", 10: "Computer Science", 11: "Economics"
}

# Draw edge labels
edge_labels = nx.get_edge_attributes(G, "weight")

# Textual labels
title = "Curriculum Subject Dependencies"
xlabel = "X-axis"
ylabel = "Y-axis"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(12, 10))

# Draw the graph with the customized styles
nx.draw(
    G, pos, node_size=1000, node_color="skyblue", 
    edge_color="gray", width=[weights[edge] * 0.1 for edge in G.edges()],
    with_labels=False, node_shape='o'
)
nx.draw_networkx_labels(G, pos, labels=labels, font_size=12, font_color="black")
nx.draw_networkx_edge_labels(G, pos, edge_labels=edge_labels, font_color="red")

# Add title and labels
plt.title(title, size=15)
plt.xlabel(xlabel, size=12)
plt.ylabel(ylabel, size=12)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot
plt.tight_layout()
plt.savefig("graph_27.pdf", bbox_inches="tight")
