
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import networkx as nx

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Define a simple weather-related network graph
G = nx.Graph()
G.add_edges_from([(0, 1), (0, 2), (1, 3), (2, 3), (3, 4)])

# Explicitly set positions (for better visualization)
pos = {
    0: (0, 0), 
    1: (1, 0), 
    2: (0, 1), 
    3: (1, 1), 
    4: (0.5, 2.0)
}

# Text labels for weather stations
labels = {
    0: "Urban Station A", 
    1: "Rural Station B", 
    2: "Rural Station C", 
    3: "Urban Station D", 
    4: "Central Station"
}

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(12, 10))

# Draw nodes with different colors and sizes
nx.draw_networkx_nodes(G, pos, node_size=2000, nodelist=[4], node_color="lightblue")
nx.draw_networkx_nodes(G, pos, node_size=1500, nodelist=[0, 3], node_color="green")
nx.draw_networkx_nodes(G, pos, node_size=1000, nodelist=[1, 2], node_color="lightgreen")

# Draw edges with varying transparency (alpha) and width
nx.draw_networkx_edges(G, pos, alpha=0.6, width=4, edge_color="blue")

# Draw labels for each node
nx.draw_networkx_labels(G, pos, labels=labels, font_size=12, font_color="black")

plt.title("Weather Station Network", fontsize=18)
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("graph_30.pdf", bbox_inches="tight")
