
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import networkx as nx

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
G = nx.house_graph()

# explicitly set positions
pos = {0: (0, 0), 1: (1, 0), 2: (0, 1), 3: (1, 1), 4: (0.5, 2.0)}

# Labels for technology context
labels = {
    0: "Server",
    1: "Router 1",
    2: "Router 2",
    3: "Switch",
    4: "Main Hub"
}

# Title and legend labels
title = "Technology Network Diagram"
legend_labels = {
    4: "Main Hub",
    0: "Server",
    1: "Router 1 / Router 2",
    3: "Switch"
}

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(12, 10))

# Draw nodes
nx.draw_networkx_nodes(G, pos, node_size=2500, nodelist=[4], node_color="#00aaff")
nx.draw_networkx_nodes(G, pos, node_size=1800, nodelist=[0], node_color="#ffaa00")
nx.draw_networkx_nodes(G, pos, node_size=1500, nodelist=[1, 2], node_color="#ff44aa")
nx.draw_networkx_nodes(G, pos, node_size=1300, nodelist=[3], node_color="#77dd77")

# Draw edges
nx.draw_networkx_edges(G, pos, alpha=0.7, width=4, edge_color="#a0a0a0")

# Adding labels
nx.draw_networkx_labels(G, pos, labels=labels, font_size=14, font_color="#333333")

# Adding a title
plt.title(title, fontsize=20)
plt.axis("off")

# Create custom legend
from matplotlib.lines import Line2D
legend_elements = [Line2D([0], [0], marker='o', color='w', label=label, 
                          markerfacecolor=color, markersize=15) 
                   for label, color in zip(legend_labels.values(), ["#00aaff", "#ffaa00", "#ff44aa", "#77dd77"])]

plt.legend(handles=legend_elements, loc='upper right', fontsize=12)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("graph_31.pdf", bbox_inches="tight")
