
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import networkx as nx
import numpy as np

# Create a directed graph with legal cases and citations
G = nx.DiGraph()
cases = ["Case A", "Case B", "Case C", "Case D", "Case E"]

# Adding nodes representing cases
for case in cases:
    G.add_node(case)

# Adding directed edges representing citations
edges = [("Case A", "Case B"), ("Case B", "Case C"), ("Case C", "Case D"), ("Case D", "Case E"), ("Case E", "Case A")]
self_loops = [("Case C", "Case C"), ("Case E", "Case E")]

G.add_edges_from(edges + self_loops)

# Define positions for a circular layout
pos = nx.circular_layout(G)

# Parameters for labels and legend
title = "Legal Precedent Network"
legend_labels = {'Regular Edges': '-', 'Self-Loops': '--'}

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(12, 10))

# Draw the main graph
nx.draw(G, pos, with_labels=True, node_color="#2E8B57", font_weight='bold', font_size=12, node_size=700, edge_color="#4682B4")

# Draw self-loops with different formatting
nx.draw_networkx_edges(G, pos, edgelist=self_loops, style="dashed", edge_color='orange', arrowstyle="-|>", arrowsize=20, connectionstyle='arc3,rad=0.3')

# Adding a legend
handles = [
    plt.Line2D([0], [0], color="#4682B4", lw=2, label='Regular Edges'),
    plt.Line2D([0], [0], color="orange", lw=2, linestyle='--', label='Self-Loops')
]
plt.legend(handles=handles, loc='best')

# Setting the title
plt.title(title, fontsize=16)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("graph_35.pdf", bbox_inches="tight")
