
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import networkx as nx
import numpy as np

# Create a simple directed graph to represent inter-departmental collaborations
G = nx.DiGraph()

# Add nodes representing different departments
departments = ["Math", "Physics", "Chemistry", "Biology", "Engineering", "Arts", "History", "Economics"]
G.add_nodes_from(departments)

# Add edges representing collaborations with weights indicating collaboration strength
collaborations = [
    ("Math", "Physics", 3),
    ("Physics", "Chemistry", 2),
    ("Chemistry", "Biology", 4),
    ("Math", "Engineering", 5),
    ("Engineering", "Physics", 3),
    ("Arts", "History", 2),
    ("History", "Economics", 3),
    ("Economics", "Math", 1),
    ("Biology", "Arts", 2),
]
G.add_weighted_edges_from(collaborations)

pos = nx.spring_layout(G, seed=42)  # Fixed layout for reproducibility

# Draw edge labels
edge_labels = nx.get_edge_attributes(G, "weight")

# Updated labels and title
title = "Inter-Departmental Collaboration Network in a University"
legend = ["Collaboration Strength"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(12, 10))

# Draw nodes with different colors and sizes based on their importance
node_sizes = [G.degree(node) * 400 for node in G.nodes()]
nx.draw_networkx_nodes(
    G, pos, node_size=node_sizes, node_color="skyblue", edgecolors="black"
)

# Draw edges with varying thickness based on weight
edge_weights = [G[u][v]["weight"] for u, v in G.edges()]
nx.draw_networkx_edges(
    G, pos, width=edge_weights, edge_color="seagreen", arrowstyle="-|>", arrowsize=12
)

# Add labels
nx.draw_networkx_labels(G, pos, font_size=12, font_weight="bold")
nx.draw_networkx_edge_labels(
    G, pos, edge_labels=edge_labels, font_color="darkred", font_size=10
)

# Add title and legend
plt.title(title, fontsize=16)
plt.legend(legend, loc="upper right")

# ===================
# Part 4: Saving Output
# ===================
# Show the plot
plt.tight_layout()
plt.savefig("graph_37.pdf", bbox_inches="tight")
