
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import networkx as nx
import numpy as np

# Create a directed graph to represent geographical interactions
G = nx.DiGraph()

# Add nodes representing different geographical features
features = ["Mountain", "River", "Forest", "City", "Desert", "Ocean", "Lake", "Village"]
G.add_nodes_from(features)

# Add edges representing interactions with weights indicating interaction strength
interactions = [
    ("Mountain", "River", 3),
    ("River", "City", 2),
    ("Forest", "Mountain", 1),
    ("City", "Forest", 2),
    ("Desert", "Village", 1),
    ("Ocean", "Lake", 4),
    ("Lake", "Village", 2),
    ("City", "Ocean", 3),
    ("Village", "Forest", 1),
]
G.add_weighted_edges_from(interactions)

pos = nx.spring_layout(G, seed=42)  # Fixed layout for reproducibility

# Draw edge labels
edge_labels = nx.get_edge_attributes(G, "weight")

title = "Geographical Interaction Network"
legend = ["Interaction Strength"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(12, 10))

# Draw nodes with different colors and sizes based on their importance
node_colors = {
    "Mountain": "gray",
    "River": "blue",
    "Forest": "green",
    "City": "red",
    "Desert": "sandybrown",
    "Ocean": "cyan",
    "Lake": "navy",
    "Village": "orange"
}
node_sizes = [G.degree(node) * 300 for node in G.nodes()]
node_color_list = [node_colors[node] for node in G.nodes()]

nx.draw_networkx_nodes(
    G, pos, node_size=node_sizes, node_color=node_color_list, edgecolors="black"
)

# Draw edges with varying thickness based on weight
edge_weights = [G[u][v]["weight"] for u, v in G.edges()]
nx.draw_networkx_edges(
    G, pos, width=edge_weights, edge_color="darkgreen", arrowstyle="-|>", arrowsize=12
)

# Add labels
nx.draw_networkx_labels(G, pos, font_size=12, font_weight="bold")
nx.draw_networkx_edge_labels(
    G, pos, edge_labels=edge_labels, font_color="blue", font_size=10
)

# Add title and legend
plt.title(title, fontsize=16)
plt.legend(legend, loc="upper right")

# ===================
# Part 4: Saving Output
# ===================
# Show the plot
plt.tight_layout()
plt.savefig("graph_38.pdf", bbox_inches="tight")
