
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import networkx as nx

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(1)
# Creating a random graph representing philosophical thinkers and their schools of thought
G = nx.random_geometric_graph(25, 0.3)

# Position the nodes using the Kamada-Kawai layout algorithm for a spread-out structure
pos = nx.kamada_kawai_layout(G)

# Randomly select some edges to color as 'influential connections'
edges = list(G.edges())
influential_connections = np.random.choice(
    len(edges), size=int(len(edges) * 0.3), replace=False
)  # Highlighting 30% of the edges
influential_connections = [edges[i] for i in influential_connections]
title = "Philosophical Thinkers and Their Influence Network"
labels = ["Influential Connections", "General Connections"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig = plt.subplots(figsize=(10, 10))

# Draw the nodes with a soft, thought-invoking color
nx.draw_networkx_nodes(
    G, pos, node_size=300, node_color="#87CEEB", edgecolors="#005073", linewidths=0.5
)

# Draw the edges with a light transparency
nx.draw_networkx_edges(G, pos, edge_color="#98D8D8", alpha=0.5)

# Draw the selected 'influential connections' edges with a distinct color
nx.draw_networkx_edges(
    G, pos, edgelist=influential_connections, edge_color="#0B3D91", width=2
)

# Add a title
plt.title(title, fontsize=16, color="#003366")

# Add a legend
influential_patch = plt.Line2D(
    [], [], color="#0B3D91", linewidth=2, linestyle="-", label=labels[0]
)
general_patch = plt.Line2D(
    [], [], color="#98D8D8", linewidth=2, linestyle="-", alpha=0.5, label=labels[1]
)
plt.legend(handles=[influential_patch, general_patch])

# Remove axis
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("graph_50.pdf", bbox_inches="tight")
