
# ===================
# Part 1: Importing Libraries
# ===================
import networkx as nx
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Create a directed graph for historical events
G = nx.DiGraph()
# Adding nodes representing historical periods/events
G.add_nodes_from(
    [
        ("Ancient", {"type": "period"}),
        ("Medieval", {"type": "period"}),
        ("Renaissance", {"type": "period"}),
        ("Modern", {"type": "period"}),
    ]
)

# Adding edges representing interactions/influences
G.add_edges_from(
    [("Ancient", "Medieval"), ("Medieval", "Renaissance"), ("Renaissance", "Modern")]
)

# Adding self-loops representing internal developments
self_loops = [
    ("Ancient", "Ancient"),
    ("Medieval", "Medieval"),
    ("Renaissance", "Renaissance"),
    ("Modern", "Modern"),
]
G.add_edges_from(self_loops)

# Positioning nodes in a circular layout
pos = nx.circular_layout(G)

# Labels for legend and title
labels = ["Historical Influence", "Internal Developments"]
title = "Interactions Between Historical Periods"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(10, 8))

# Draw nodes and edges with base settings
nx.draw(
    G,
    pos,
    with_labels=True,
    node_color="saddlebrown",
    node_size=3000,
    edge_color="olive",
    linewidths=1.5,
    font_size=12,
    font_weight="bold",
)

# Highlight self-loops with a different style
nx.draw_networkx_edges(
    G,
    pos,
    edgelist=self_loops,
    edge_color="darkgreen",
    style="dashed",
    arrowstyle="<|-",
    arrowsize=20,
    width=2,
)

# Adding title and legend
plt.title(title, fontsize=16)
edge_legend = plt.Line2D([], [], linestyle="solid", color="olive", label=labels[0])
self_loop_legend = plt.Line2D(
    [], [], linestyle="dashed", color="darkgreen", label=labels[1]
)
plt.legend(handles=[edge_legend, self_loop_legend])

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("graph_57.pdf", bbox_inches="tight")
