
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import networkx as nx

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Create a directed graph
G = nx.DiGraph()

# Define nodes with supply chain stages and colors
nodes = {
    0: ("Supplier", "#1f77b4"),  # blue
    1: ("Manufacturer", "#ff7f0e"),  # orange
    2: ("Warehouse", "#2ca02c"),  # green
    3: ("Distributor", "#d62728"),  # red
    4: ("Retailer", "#9467bd"),  # purple
}
for node, (stage, color) in nodes.items():
    G.add_node(node, stage=stage, color=color)

# Add edges with labels representing interactions
edges = [
    (0, 1, "Raw Materials"),
    (1, 2, "Manufactured Goods"),
    (2, 3, "Inventory Transfer"),
    (3, 4, "Product Delivery"),
]
for u, v, label in edges:
    G.add_edge(u, v, label=label)

# Define node positions in a circular layout
pos = nx.circular_layout(G)

title = "Business Supply Chain Network"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(10, 10))

# Draw nodes with color attribute
node_colors = [G.nodes[node]["color"] for node in G.nodes]
nx.draw_networkx_nodes(G, pos, node_color=node_colors, node_size=800, ax=ax)

# Draw edges with labels
nx.draw_networkx_edges(
    G,
    pos,
    arrows=True,
    arrowstyle="-|>",
    arrowsize=20,
    width=2,
    edge_color="#555555",
    ax=ax,
)
edge_labels = {(u, v): G[u][v]["label"] for u, v in G.edges}
nx.draw_networkx_edge_labels(
    G, pos, edge_labels=edge_labels, font_color="#4B0082", font_size=10, ax=ax
)

# Draw node labels indicating supply chain stages
node_labels = {node: G.nodes[node]["stage"] for node in G.nodes}
nx.draw_networkx_labels(
    G, pos, labels=node_labels, font_size=12, font_color="#000000", ax=ax
)

# Remove axis and add title
plt.axis("off")
plt.title(title, fontsize=16, fontweight="bold")

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("graph_63.pdf", bbox_inches="tight")
