
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import networkx as nx
import numpy as np

# Create a directed graph representing financial departments
G = nx.DiGraph()

# Add nodes representing different financial departments
modules = {
    0: "Accounting",
    1: "Corporate Finance",
    2: "Investment Banking",
    3: "Risk Management",
    4: "Treasury",
    5: "Internal Audit",
    6: "Compliance",
    7: "Tax",
    8: "Investor Relations",
    9: "Financial Planning",
    10: "Credit Analysis",
    11: "Portfolio Management",
}

G.add_nodes_from(modules.keys())

# Add edges with weights representing communication flow or collaboration (weight = frequency/importance)
edges = [
    (0, 1, 3),
    (1, 2, 4),
    (1, 9, 2),
    (2, 3, 4),
    (3, 4, 3),
    (3, 5, 2),
    (4, 7, 2),
    (5, 6, 1),
    (6, 10, 4),
    (7, 8, 3),
    (8, 10, 4),
    (10, 11, 2),
]

G.add_weighted_edges_from(edges)

# Adjust node positions using spring layout for better visualization
pos = nx.spring_layout(G, seed=42)
title = "Finance Units and Their Collaboration Relationships"

# Labels for nodes and edges
node_labels = modules
edge_labels = {(start, end): f"{weight}" for start, end, weight in edges}

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(14, 10))

# Draw nodes with varying sizes and more sophisticated color palette
node_size = [1000 + 300 * (i % 3) for i in range(len(modules))]
node_color = [
    "mediumseagreen" if i % 3 == 0 else "cornflowerblue" if i % 3 == 1 else "gray"
    for i in range(len(modules))
]

nx.draw(
    G, pos, node_size=node_size, node_color=node_color, with_labels=False, arrows=True, edge_color='black'
)

# Draw labels for nodes and edges
nx.draw_networkx_labels(G, pos, labels=node_labels, font_size=10, font_color='darkblue')
nx.draw_networkx_edge_labels(G, pos, edge_labels=edge_labels, font_color="darkred", font_size=8)

# Adjust plot parameters for better visualization
plt.title(title, fontsize=16, fontweight='bold')
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Show the plot
plt.tight_layout()
plt.savefig("graph_67.pdf", bbox_inches="tight")
