
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import networkx as nx
import random

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(0)
random.seed(42)

# Create a random communication network graph
G = nx.random_geometric_graph(30, 0.5)

# Position the nodes based on their connections using a layout algorithm
pos = nx.spring_layout(G)

# Randomly select some edges to highlight
edges = list(G.edges())
highlighted_edges = np.random.choice(
    len(edges), size=int(len(edges) * 0.3), replace=False)
highlighted_edges = [edges[i] for i in highlighted_edges]

# Set labels and titles
title = "Communication Network Visualization"
legend_labels = ["Regular Connections", "Highlighted Connections"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(10, 10))

# Draw the nodes
nx.draw_networkx_nodes(G, pos, node_size=300, node_color="#17becf", ax=ax)

# Draw the edges
nx.draw_networkx_edges(G, pos, edgelist=edges, alpha=0.3, edge_color="#7f7f7f", ax=ax)

# Draw the highlighted edges in blue
nx.draw_networkx_edges(
    G, pos, edgelist=highlighted_edges, edge_color="#1f77b4", width=2, alpha=0.6, ax=ax)

# Add legend
highlight_line = plt.Line2D([0], [0], color="#1f77b4", linewidth=2, alpha=0.6)
regular_line = plt.Line2D([0], [0], color="#7f7f7f", linewidth=2, alpha=0.3)
plt.legend([regular_line, highlight_line], legend_labels, loc="upper left", fontsize=12)

# Title and axis settings
plt.title(title, fontsize=18)
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("graph_74.pdf", bbox_inches="tight")
