
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import networkx as nx

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Creating a simple tourism attractions network graph
G = nx.Graph()
G.add_edges_from([(0, 1), (0, 2), (1, 3), (2, 3), (2, 4), (3, 4)])

# Set positions for the nodes explicitly
pos = {
    0: (0, 0),
    1: (3, 1),
    2: (1.5, 4),
    3: (3, 3),
    4: (5, 2)
}

# Labels for the tourist attractions
labels = {
    0: "Historical Site",
    1: "Park",
    2: "Museum",
    3: "Shopping District",
    4: "Cultural Center"
}

# Title and subtitle for the chart
title = "Tourist Attractions and Routes in the City"
suptitle = "Connections and Travel Routes Between Key Attractions"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(12, 10))

# Nodes configuration
nx.draw_networkx_nodes(
    G,
    pos,
    node_size=200,
    nodelist=[0],
    node_color="skyblue",
    edgecolors="black",
    linewidths=2,
    node_shape="o",  # Circle
)

nx.draw_networkx_nodes(
    G,
    pos,
    node_size=300,
    nodelist=[1, 2],
    node_color="lightgreen",
    edgecolors="black",
    linewidths=2,
    node_shape="s",  # Square
)

nx.draw_networkx_nodes(
    G,
    pos,
    node_size=300,
    nodelist=[3, 4],
    node_color="lightpink",
    edgecolors="black",
    linewidths=2,
    node_shape="^",  # Triangle
)

# Edges configuration
nx.draw_networkx_edges(G, pos, alpha=0.6, width=2, edge_color="gray", style="solid")

# Adding text annotations - Labels for attractions
nx.draw_networkx_labels(
    G, pos, labels=labels, font_size=14, font_color="black", font_family="sans-serif"
)

# Title and axis configurations
plt.title(title, fontsize=24, fontweight="bold")
plt.suptitle(suptitle, fontsize=16, style="italic")
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("graph_76.pdf", bbox_inches="tight")
