
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Generate a seed for reproducibility
np.random.seed(0)

# Hypothetical test score methods (classes and subjects)
methods = [
    "Math",
    "Science",
    "History",
    "English",
    "Physics",
    "Chemistry",
    "Biology",
    "Geography",
    "Art",
    "Music",
    "PE",
    "Literature",
    "Algebra",
    "Geometry",
    "Statistics",
    "Computer Science",
    "Economics",
    "Philosophy",
]

# Generate a random grid of scores between 50 to 100 for better visualization
grid = 50 + np.random.rand(4, 4) * 50

# Labels for the chart
xlabel = "Subjects"
ylabel = "Classes"
title = "Average Test Scores Across Subjects and Classes"
suptitle = "Heatmap of Test Scores"
legend_labels = methods

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, axs = plt.subplots(
    nrows=3, ncols=6, figsize=(12, 8), subplot_kw={"xticks": [], "yticks": []}
)

for ax, interp_method in zip(axs.flat, methods):
    cax = ax.imshow(grid, interpolation="nearest", cmap="coolwarm")
    ax.set_title(interp_method, fontsize=10)
    
# Adjust layout and add a supertitle
fig.suptitle(suptitle, fontsize=16)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout(rect=[0, 0.03, 1, 0.95])
plt.savefig("heatmap_106.pdf", bbox_inches="tight")
