
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
methods = [
    None,
    "none",
    "nearest",
    "bilinear",
    "bicubic",
    "spline16",
    "spline36",
    "hanning",
    "hamming",
    "hermite",
    "kaiser",
    "quadric",
    "catrom",
    "gaussian",
    "bessel",
    "mitchell",
    "sinc",
    "lanczos",
]

grid = np.random.rand(4, 4)

# Define Titles and Labels
suptitle = "Interpolation Methods in Art and Design"
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, axs = plt.subplots(
    nrows=3, ncols=6, figsize=(12, 8), subplot_kw={"xticks": [], "yticks": []}
)

for ax, interp_method in zip(axs.flat, methods):
    ax.imshow(grid, interpolation=interp_method, cmap="plasma")
    ax.set_title(str(interp_method), fontsize=10, fontweight='bold')

fig.suptitle(suptitle, fontsize=16, fontweight='bold')

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout(rect=[0, 0.03, 1, 0.95])
plt.savefig("heatmap_107.pdf", bbox_inches="tight")
