
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
methods = [
    None,
    "none",
    "nearest",
    "bilinear",
    "bicubic",
    "spline16",
    "spline36",
    "hanning",
    "hamming",
    "hermite",
    "kaiser",
    "quadric",
    "catrom",
    "gaussian",
    "bessel",
    "mitchell",
    "sinc",
    "lanczos",
]

grid = np.random.rand(4, 4)

# Labels and Titles
main_title = "Art and Design: Interpolation Methods Visualization"
suptitle = "Comparison of Different Interpolation Methods on a Random Grid"
subtitle = "Method: {}"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, axs = plt.subplots(
    nrows=3, ncols=6, figsize=(12, 8), subplot_kw={"xticks": [], "yticks": []}
)

for ax, interp_method in zip(axs.flat, methods):
    ax.imshow(grid, interpolation=interp_method, cmap="inferno")
    ax.set_title(subtitle.format(str(interp_method)), fontsize=8)

fig.suptitle(main_title, fontsize=16, fontweight='bold')
fig.subplots_adjust(top=0.9)
fig.text(0.5, 0.90, suptitle, ha='center', fontsize=12, style='italic')

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout(rect=[0, 0, 1, 0.95])
plt.savefig("heatmap_108.pdf", bbox_inches="tight")
