
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib.colors import LogNorm

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Generating plausible data for a basketball team's performance over 10 games
Z = np.random.randint(50, 150, size=(6, 10))

titles = ["Game Performance Metrics: No Edges", "Game Performance Metrics: Thick Edges"]
xlabel = "Games"
ylabel = ["Points", "Assists", "Rebounds", "Steals", "Blocks", "Turnovers"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, (ax0, ax1) = plt.subplots(2, 1, figsize=(8, 6))

# First subplot without edges
c0 = ax0.pcolor(Z, cmap="viridis")
ax0.set_title(titles[0])
ax0.set_xlabel(xlabel)
ax0.set_yticks(np.arange(0.5, len(ylabel), 1))
ax0.set_yticklabels(ylabel)
fig.colorbar(c0, ax=ax0)

# Second subplot with thick edges
c1 = ax1.pcolor(Z, edgecolors="w", linewidths=2, cmap="viridis")
ax1.set_title(titles[1])
ax1.set_xlabel(xlabel)
ax1.set_yticks(np.arange(0.5, len(ylabel), 1))
ax1.set_yticklabels(ylabel)
fig.colorbar(c1, ax=ax1)

# ===================
# Part 4: Saving Output
# ===================
fig.tight_layout()
plt.savefig("heatmap_110.pdf", bbox_inches="tight")

