
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib.colors import LogNorm

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Generating new data for technology adoption rates
np.random.seed(0)
Z = np.random.rand(6, 10) * 100  # Scale to represent percentages

# Labels and titles
months = ["Jan", "Feb", "Mar", "Apr", "May", "Jun"]
sectors = ["Sector {}".format(i) for i in range(1, 11)]
titles = ["Adoption Rates: No Edges", "Adoption Rates: Thick Edges"]

# Axis labels
xlabel = "Sectors"
ylabel = "Months"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, (ax0, ax1) = plt.subplots(2, 1, figsize=(10, 8))

# First subplot: Adoption rates without edges
c0 = ax0.pcolor(Z, cmap="inferno")
ax0.set_title(titles[0])
ax0.set_xlabel(xlabel)
ax0.set_ylabel(ylabel)
ax0.set_xticks(np.arange(len(sectors)) + 0.5, labels=sectors)
ax0.set_yticks(np.arange(len(months)) + 0.5, labels=months)
fig.colorbar(c0, ax=ax0)

# Second subplot: Adoption rates with thick edges
c1 = ax1.pcolor(Z, edgecolors="k", linewidths=2, cmap="inferno")
ax1.set_title(titles[1])
ax1.set_xlabel(xlabel)
ax1.set_ylabel(ylabel)
ax1.set_xticks(np.arange(len(sectors)) + 0.5, labels=sectors)
ax1.set_yticks(np.arange(len(months)) + 0.5, labels=months)
fig.colorbar(c1, ax=ax1)

# ===================
# Part 4: Saving Output
# ===================
fig.tight_layout()
plt.savefig("heatmap_111.pdf", bbox_inches="tight")
