
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Set random seed for reproducibility
np.random.seed(0)

# Cities and Months
cities = ["City A", "City B", "City C", "City D", "City E", "City F", "City G"]
months = [
    "Jan", "Feb", "Mar", "Apr", "May", "Jun",
    "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"
]

# Generate random temperature data (in Celsius)
temperatures = np.random.uniform(low=-5, high=30, size=(7, 12))

# Chart text and labels
title = "Average Monthly Temperatures of Cities (°C)"
xlabel = "Months"
ylabel = "Cities"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(10, 8))

# Use a color map that ranges from cool to warm
im = ax.imshow(temperatures, cmap="coolwarm")

# Show all ticks and label them with the respective list entries
ax.set_xticks(np.arange(len(months)), labels=months)
ax.set_yticks(np.arange(len(cities)), labels=cities)

# Rotate the tick labels and set their alignment.
plt.setp(ax.get_xticklabels(), rotation=45, ha="right", rotation_mode="anchor")

# Loop over data dimensions and create text annotations.
for i in range(len(cities)):
    for j in range(len(months)):
        text = ax.text(j, i, f"{temperatures[i, j]:.1f}", ha="center", va="center", color="black")

# Set labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)

# ===================
# Part 4: Saving Output
# ===================
fig.tight_layout()
plt.savefig("heatmap_114.pdf", bbox_inches="tight")
