
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.colors as colors

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data

data = [
    [12, 45, 85, 40],  # Intuition
    [28, 65, 15, 75],  # Logic
    [22, 60, 55, 10],  # Ethics
    [18, 85, 30, 20],  # Metaphysics
]
yticklabels = ["Low", "Medium", "High"]
title = "Philosophical Concept Emphasis"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# with purple and gold colors
colors_list = ["#6a0dad", "#ffd700"]
cmap = colors.ListedColormap(colors_list)
plt.figure(figsize=(6, 5))

# Plot the heatmap with custom colors and annotations
plt.imshow(data, cmap=cmap, vmin=0, vmax=100, extent=[0, 4, 0, 4])
for i in range(4):
    for j in range(4):
        plt.annotate(
            str(data[i][j]),
            xy=(j + 0.5, i + 0.5),
            ha="center",
            va="center",
            color="black",
            fontsize=10,
            fontweight='bold'
        )

# Add colorbar
cbar = plt.colorbar(ticks=[0, 50, 100])
cbar.ax.set_yticklabels(yticklabels)

# Set plot title and axis labels
plt.title(title, fontsize=14, fontweight='bold')
plt.xticks([0.5, 1.5, 2.5, 3.5], ["Intuition", "Logic", "Ethics", "Metaphysics"], rotation=45, ha="right")
plt.yticks([])

# ===================
# Part 4: Saving Output
# ===================
# Display the plot
plt.tight_layout()
plt.savefig("heatmap_115.pdf", bbox_inches="tight")
